/*:
 * @target MZ
 * @plugindesc Spine重複掃除（ロード後に同一IDが二重表示されるのを自動除去）@author HS
 *
 * @help
 * PKD_Spine2D使用時、ロード直後に「止まっている立ち絵」と「動いている立ち絵」が
 * 重なって見えるケースを自動で解消します。管理マップは変更せず、表示ツリーから外すのみ。
 *
 * @param runAfterFrames
 * @text 実行までの待ちフレーム
 * @type number
 * @min 0 @max 300
 * @default 24
 *
 * @param debugLog
 * @text デバッグログ
 * @type boolean
 * @default false
 */
(() => {
  "use strict";
  const PN = "HS_SpineAfterLoadDedupe";
  const P  = PluginManager.parameters(PN);
  const WAIT = Math.max(0, Number(P.runAfterFrames || 24));
  const DEBUG = String(P.debugLog || "false") === "true";
  const log   = (...a)=>{ if (DEBUG) console.log(`[${PN}]`, ...a); };

  function layers(){
    const s = SceneManager._scene;
    if (!s) return [];
    const arr = [s];
    try {
      if (s._spriteset){
        arr.push(s._spriteset._tilemap);
        arr.push(s._spriteset._pkdSpineBelowPicturesLayer);
        arr.push(s._spriteset._pkdSpineBelowWindowsLayer);
      }
    } catch(e){}
    return arr.filter(Boolean);
  }
  function detach(node){
    try { if (node && node.parent) node.parent.removeChild(node); }
    catch(e){ console.warn(e); }
  }
  function dedupeOnce(){
    const dict = $gameTemp && $gameTemp._pSpineAnimations;
    if (!dict) return;
    Object.keys(dict).forEach(id => {
      const keep = window.SAnim ? window.SAnim(id) : null; // 辞書に載っている“正規”だけ残す
      if (!keep) return;
      let removed = 0;
      for (const L of layers()){
        if (!L || !Array.isArray(L.children)) continue;
        for (const child of [...L.children]){
          try {
            if (child instanceof window.PKD_Sprite_SpineAnimation){
              if (child.id === id && child !== keep){ detach(child); removed++; }
            } else if (child instanceof window.PKD_Sprite_SpineMapInst){
              if (child.id === id){
                const sp = child.spline && child.spline();
                if (sp && sp !== keep){ detach(child); removed++; }
              }
            }
          } catch(e){}
        }
      }
      if (removed>0) log(`dedupe: id=${id} removed=${removed}`);
      try { if ($gameTemp && $gameTemp.pAddSpineAnimationSprite) $gameTemp.pAddSpineAnimationSprite(keep); } catch(e){}
    });
  }

  // Map.start→一定フレーム後に一度だけ実行
  const _start = Scene_Map.prototype.start;
  Scene_Map.prototype.start = function(){
    _start.call(this);
    this.__hs_dedup_wait = WAIT;
    this.__hs_dedup_done = false;
    if (this.__hs_dedup_wait >= 0) log(`will dedupe in ${this.__hs_dedup_wait} frames`);
  };
  const _update = Scene_Map.prototype.update;
  Scene_Map.prototype.update = function(){
    _update.call(this);
    if (this.__hs_dedup_done) return;
    if (this.__hs_dedup_wait == null) return;
    if (this.__hs_dedup_wait-- > 0) return;
    try { dedupeOnce(); } catch(e){ console.warn(e); }
    this.__hs_dedup_done = true;
  };
})();
